#ifndef __RectUtils__
#define __RectUtils__


#if EG_WIN
#ifndef Rect_Defined
struct Rect {
	short left, top, right, bottom;
};
#define Rect_Defined
#endif

extern short 		PtInRect( const Point& inPt, const Rect* inRect );
extern void			SetRect( Rect* inR, long left, long top, long right, long bot );
extern void			InsetRect( Rect* inR, int inDelX, int inDelY );
extern void			UnionRect( const Rect* inR1, const Rect* inR2, Rect* outRect );
extern void			OffsetRect( Rect* inRect, int inDelX, int inDelY );
extern void			SectRect( const Rect* inR1, const Rect* inR2, Rect* outRect );
#endif

#if EG_MAC
#include <QuickDraw.h>
#endif

extern void			UnionPt( long x, long y, Rect* ioRect );

#endif